% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_profile.R
\name{clean_profile}
\alias{clean_profile}
\title{Preprocess a co-elution profile}
\usage{
clean_profile(
  chromatogram,
  impute_NA = TRUE,
  smooth = TRUE,
  smooth_width = 4,
  noise_floor = 0.001
)
}
\arguments{
\item{chromatogram}{a numeric vector corresponding to the chromatogram trace}

\item{impute_NA}{if true, impute single missing values with the average of
neighboring values}

\item{smooth}{if true, smooth the chromatogram with a moving average filter}

\item{smooth_width}{width of the moving average filter, in fractions}

\item{noise_floor}{mean value of the near-zero noise to add}
}
\value{
a cleaned profile
}
\description{
Clean a co-elution/co-fractionation profile by (1) imputing single missing
values with the average of neighboring values, (2) replacing missing values
with random, near-zero noise, and (3) smoothing with a moving average
filter.
}
\examples{
data(scott)
chrom <- scott[16, ]
cleaned <- clean_profile(chrom)

}
