#' Fitted Gaussian mixture models for the \code{kristensen} dataset
#' 
#' The \code{\link[PrInCE]{kristensen}} dataset consists of protein
#' co-migration profiles derived from size exclusion chromatography (SEC) of
#' unstimulated HeLa cell lysates. 
#' The \code{kristensen_gaussians} object contains Gaussian mixture models fit by
#' the function \code{\link[PrInCE]{build_gaussians}}; this is bundled with the
#' R package in order to expedite the demonstration code, as the process of 
#' Gaussian fitting is one of the more time-consuming aspects of the package. 
#' 
#' As with the \code{\link[PrInCE]{kristensen}} dataset, the code used to
#' generate this data object is provided in the \code{data-raw} directory of the
#' package source.
#'
#' @docType data
#' @usage data(kristensen_gaussians)
#' @format a named list with 1117 entries; names are proteins, and list items 
#'   conain information about fitted Gaussians in the format that PrInCE expects
"kristensen_gaussians"