% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseDomainInput.R
\name{parseDomainInput}
\alias{parseDomainInput}
\title{Parse domain input file}
\usage{
parseDomainInput(seed = NULL, inputFile = NULL, type = "file")
}
\arguments{
\item{seed}{seed protein ID}

\item{inputFile}{name of input file (file name or path to folder contains
individual domain files)}

\item{type}{type of data (file" or "folder"). Default = "file".}
}
\value{
A dataframe for protein domains including seed ID, its orthologs IDs,
sequence lengths, feature names, start and end positions, feature weights
(optional) and the status to determine if that feature is important for
comparison the architecture between 2 proteins* (e.g. seed protein vs
ortholog) (optional).
}
\description{
Get all domain annotations for one seed protein IDs.
}
\examples{
seed <- "101621at6656"
inputFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
type <- "file"
parseDomainInput(seed, inputFile, type)
}
\seealso{
\code{\link{getDomainFolder}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
