% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterProfile.R
\name{getDendrogram}
\alias{getDendrogram}
\title{Plot dendrogram tree}
\usage{
getDendrogram(dd = NULL)
}
\arguments{
\item{dd}{dendrogram object (see ?clusterDataDend)}
}
\value{
A dendrogram plot for the genes in the input phylogenetic profiles.
}
\description{
Plot dendrogram tree
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
data <- finalProcessedProfile
profileType <- "binary"
profiles <- getDataClustering(
    data, profileType, var1AggregateBy, var2AggregateBy)
distMethod <- "mutualInformation"
distanceMatrix <- getDistanceMatrix(profiles, distMethod)
clusterMethod <- "complete"
dd <- clusterDataDend(as.dist(distanceMatrix), clusterMethod)
getDendrogram(dd)
}
\seealso{
\code{\link{clusterDataDend}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
