% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{loeweCI}
\alias{loeweCI}
\title{Loewe Additive Combination Index (CI)}
\usage{
loeweCI(
  viability,
  treatment1dose,
  HS_1,
  E_inf_1,
  EC50_1,
  treatment2dose,
  HS_2,
  E_inf_2,
  EC50_2,
  is_pct = FALSE
)
}
\arguments{
\item{viability}{\code{numeric} is a vector whose entries are the viability values
in the range [0, 1].}

\item{treatment1dose}{\code{numeric} a vector of concentrations for treatment 1}

\item{HS_1}{\code{numeric} Hill coefficient of treatment 1}

\item{E_inf_1}{\code{numeric} the maximum attainable effect of treatment 1.}

\item{EC50_1}{\code{numeric} relative EC50 of treatment 1.}

\item{treatment2dose}{\code{numeric} a vector of concentrations for treatment 2}

\item{HS_2}{\code{numeric} Hill coefficient of treatment 2}

\item{E_inf_2}{\code{numeric} the maximum attainable effect of treatment 2.}

\item{EC50_2}{\code{numeric} relative EC50 of treatment 2.}

\item{is_pct}{\code{logical} whether both the input viabiliy and E_inf are given
in percentage ([0, 100]) rather than decimal ([0, 1]). Default FALSE.}
}
\value{
CI under Loewe additive definition
}
\description{
Computes the Loewe additive combination index (CI) from its definition
\eqn{
    CI = \frac{x_1}{f_1^{-1}(E)} +
         \frac{x_2}{f_2^{-1}(E)}
}
}
\examples{
\dontrun{
tre |>
    endoaggregate(
        assay="combo_viability",
        Loewe = PharmacoGx::computeLoewe(
            treatment1dose = treatment1dose,
            treatment2dose = treatment2dose,
            HS_1 = HS_1,
            HS_2 = HS_2,
            E_inf_1 = E_inf_1,
            E_inf_2 = E_inf_2,
            EC50_1 = EC50_1,
            EC50_2 = EC50_2
        ),
        by = assayKeys(tre, "combo_viability")
    ) -> tre
}

}
