% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{estimateProjParams}
\alias{estimateProjParams}
\title{Estimate the projected Hill coefficient, efficacy, and potency}
\usage{
estimateProjParams(
  dose_to,
  combo_viability,
  dose_add,
  EC50_add,
  HS_add,
  E_inf_add = 0,
  residual = c("logcosh", "normal", "Cauchy"),
  show_Rsqr = TRUE,
  conc_as_log = FALSE,
  optim_only = FALSE,
  loss_args = list()
)
}
\arguments{
\item{dose_to}{\code{numeric} a vector of concentrations of the drug being added to}

\item{combo_viability}{\code{numeric} observed viability of two treatments; target for fitting curve.}

\item{dose_add}{\code{numeric} a vector of concentrations of the drug added.}

\item{EC50_add}{\code{numeric} relative EC50 of the drug added.}

\item{HS_add}{\code{numeric} Hill coefficient of the drug added.}

\item{E_inf_add}{\code{numeric} Efficacy of the drug added.}

\item{residual}{\code{character} Method used to minimise residual in fitting curves.
3 methods available: \code{logcosh}, \code{normal}, \code{Cauchy}.
The default method is \code{logcosh}.
It minimises the logarithmic hyperbolic cosine loss of the residuals
and provides the fastest estimation among the three methods,
with fitting quality in between \code{normal} and \code{Cauchy};
recommanded when fitting large-scale datasets.
The other two methods minimise residuals by
considering the truncated probability distribution (as in their names) for the residual.
\code{Cauchy} provides the best fitting quality but also takes the longest to run.}

\item{show_Rsqr}{\code{logical} whether to show goodness-of-fit value in the result.}

\item{conc_as_log}{\code{logical} indicates whether input concentrations are in log10 scale.}

\item{optim_only}{\code{logical(1)} Should the fall back methods when optim fails}

\item{loss_args}{\code{list} Additional argument to the \code{loss} function.
These get passed to losss via \code{do.call} analagously to using \code{...}.}
}
\value{
\code{list}
* \code{HS_proj}: Projected Hill coefficient after adding a drug
* \code{E_inf_proj}: Projected efficacy after adding a drug
* \code{EC50_proj}: Projected potency after adding a drug
* \code{E_ninf_proj}: Projected baseline viability by the added drug
* \code{Rsqr}: if \code{show_Rsqr} is \code{TRUE}, it will include the R squared value indicating the quality of the fit in the result.
}
\description{
Estimate the projected shape parameter HS, efficacy \code{E_inf} and potency \code{EC50}
in the new dose-response curve of a drug after adding another drug to it
by fitting a 2-parameter dose-response curve.
}
\references{
Motulsky, H., & Christopoulos, A. (2004). Fitting dose-response curves. In Fitting models to biological data using linear and nonlinear regression: A practical guide to curve fitting. Oxford University Press.
}
