% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PharmacoSet-utils.R
\name{PharmacoSet-utils}
\alias{PharmacoSet-utils}
\alias{subsetBySample,PharmacoSet-method}
\alias{subsetBySample}
\alias{subsetBySample,CoreSet-method}
\alias{subsetByTreatment,PharmacoSet-method}
\alias{subsetByTreatment}
\alias{subsetByFeature,PharmacoSet-method}
\alias{subsetByFeature}
\title{Utility methods for a \code{PharmacoSet} object.}
\usage{
\S4method{subsetBySample}{PharmacoSet}(x, samples)

\S4method{subsetByTreatment}{PharmacoSet}(x, treatments)

\S4method{subsetByFeature}{PharmacoSet}(x, features, mDataTypes)
}
\arguments{
\item{x}{A \code{PharmacoSet} object.}

\item{samples}{\code{character()} vector of sample names. Must be valid rownames
from \code{sampleInfo(x)}.}

\item{treatments}{\code{character()} vector of treatment names. Must be valid
rownames from \code{treatmentInfo(x)}. This method does not work with
\code{CoreSet} objects yet.}

\item{features}{\code{character()} vector of feature names. Must be valid feature
names for a given \code{mDataType}}

\item{mDataTypes}{\code{character()} One or more molecular data types to
to subset features by. Must be valid rownames for the selected
SummarizedExperiment mDataTypes.}
}
\value{
See details.
}
\description{
Documentation for utility methods for a \code{PharmacoSet} object, such as
set operations like subset and intersect. See @details for information
on different types of methods and their implementations.
}
\details{
\subsection{subset methods}{

\strong{subsetBySample}: Subset a \code{PharmacoSet} object by sample identifier.
\itemize{
\item value: a \code{PharmacoSet} object containing only \code{samples}.
}
}

\subsection{subset methods}{

\strong{subsetByTreatment}: Subset a \code{PharmacoSet} object by treatment identifier.
\itemize{
\item value: a \code{PharmacoSet} object containing only \code{treatments}.
}
}

\subsection{subset methods}{

\strong{subsetByFeature}: Subset a \code{PharmacoSet} object by molecular feature
identifier.
\itemize{
\item value: a \code{PharmacoSet} object containing only \code{features}.
}
}
}
\examples{
data(CCLEsmall)

## subset methods

### subsetBySample
samples <- sampleInfo(CCLEsmall)$sampleid[seq_len(10)]
CCLEsmall_sub <- subsetBySample(CCLEsmall, samples)


## subset methods

### subsetByTreatment
#treatments <- drugInfo(CCLEsmall)$drugid[seq_len(10)]
#CCLEsmall_sub <- subsetByTreatment(CCLEsmall, treatments)


## subset methods

### subsetByFeature
features <- fNames(CCLEsmall, 'rna')[seq_len(5)]
CCLEsmall_sub <- subsetByFeature(CCLEsmall, features, 'rna')

}
