% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fromdf.R
\name{plot_fromdf}
\alias{plot_fromdf}
\title{Create a plot from a data.frame}
\usage{
plot_fromdf(
  df,
  usr = NULL,
  title = NULL,
  ggplot_gen = FALSE,
  boxw = 1,
  boxh = 1,
  add_to_existing = FALSE,
  title_cex = 2
)
}
\arguments{
\item{df}{A data.frame with the following columns:
\itemize{
\item \code{type}: The type of element to plot. Can be \code{text},
\code{segments}, \code{arc} or other polygons.
For polygons, the name of the polygon must be in the form
\verb{poly_*_*} where poly is one of the type given by
\code{\link[=polygons]{polygons()}}, the first \code{*} is the number
of slice in the polygon and the second \code{*} is the
position of the division of the polygon.
\item \code{x0}: The x coordinate of the center of the element.
\item \code{y0}: The y coordinate of the center of the element.
\item \code{x1}: The x coordinate of the end of the element.
Only used for \code{segments} and \code{arc}.
\item \code{y1}: The y coordinate of the end of the element.
Only used for \code{segments} and \code{arc}.
\item \code{fill}: The fill color of the element.
\item \code{border}: The border color of the element.
\item \code{density}: The density of the element.
\item \code{angle}: The angle of the element.
\item \code{label}: The label of the element. Only used for \code{text}.
\item \code{cex}: The size of the element.
\item \code{adjx}: The x adjustment of the element. Only used for \code{text}.
\item \code{adjy}: The y adjustment of the element. Only used for \code{text}.
}}

\item{usr}{The user coordinates of the plot.}

\item{title}{The title of the plot.}

\item{ggplot_gen}{If TRUE add the segments to the ggplot object}

\item{boxw}{Width of the polygons elements}

\item{boxh}{Height of the polygons elements}

\item{add_to_existing}{If \code{TRUE}, the plot will be added to the current
plot.}

\item{title_cex}{The size of the title.}
}
\value{
an invisible ggplot object and a plot on the current plotting device
}
\description{
This function is used to create a plot from a data.frame.

If \code{ggplot_gen = TRUE}, the plot will be generated with ggplot2 and
will be returned invisibly.
}
\examples{
data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == 1,])
lst <- ped_to_plotdf(ped1)
if (interactive()) {
    plot_fromdf(lst$df, lst$par_usr$usr,
        boxw = lst$par_usr$boxw, boxh = lst$par_usr$boxh
    )
}
}
\keyword{Pedigree-plot}
\keyword{internal,}
