% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_colors.R
\name{generate_colors}
\alias{generate_colors}
\alias{generate_colors,character-method}
\alias{generate_colors,numeric-method}
\alias{generate_colors,Pedigree-method}
\title{Process the filling and border colors based on affection and
availability}
\usage{
\S4method{generate_colors}{character}(
  obj,
  avail,
  mods_aff = NULL,
  is_num = FALSE,
  keep_full_scale = FALSE,
  colors_aff = c("yellow2", "red"),
  colors_unaff = c("white", "steelblue4"),
  colors_avail = c("green", "black"),
  colors_na = "grey"
)

\S4method{generate_colors}{numeric}(
  obj,
  avail,
  threshold = 0.5,
  sup_thres_aff = TRUE,
  is_num = TRUE,
  keep_full_scale = FALSE,
  breaks = 3,
  colors_aff = c("yellow2", "red"),
  colors_unaff = c("white", "steelblue4"),
  colors_avail = c("green", "black"),
  colors_na = "grey"
)

\S4method{generate_colors}{Pedigree}(
  obj,
  col_aff = "affection",
  add_to_scale = TRUE,
  col_avail = "avail",
  is_num = NULL,
  mods_aff = TRUE,
  threshold = 0.5,
  sup_thres_aff = TRUE,
  keep_full_scale = FALSE,
  breaks = 3,
  colors_aff = c("yellow2", "red"),
  colors_unaff = c("white", "steelblue4"),
  colors_avail = c("green", "black"),
  colors_na = "grey",
  reset = TRUE
)
}
\arguments{
\item{obj}{A Pedigree object or a vector containing the affection status for
each individuals. The affection status can be numeric or a character.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{mods_aff}{Vector of modality to consider as affected in the case
where the \code{values} is a factor.}

\item{is_num}{Boolean defining if the values need to be considered as
numeric.}

\item{keep_full_scale}{Boolean defining if the affection values need to
be set as a scale. If \code{values} is numeric the filling scale will be
calculated based on the values and the number of breaks given.
If \code{values} isn't numeric then each levels will get it's own color}

\item{colors_aff}{Set of increasing colors to use for the filling of the
affected individuls.}

\item{colors_unaff}{Set of increasing colors to use for the filling of the
unaffected individuls.}

\item{colors_avail}{Set of 2 colors to use for the box's border of an
individual. The first color will be used for available individual
(\code{avail == 1}) and the second for the unavailable individual
(\code{avail == 0}).}

\item{colors_na}{Color to use for individuals with no informations.}

\item{threshold}{Numeric value separating the affected and healthy subject
in the case where the \code{values} is numeric.}

\item{sup_thres_aff}{Boolean defining if the affected individual are above
the threshold or not.
If \code{TRUE}, the individuals will be considered affected
if the value of \code{values} is stricly above the \code{threshold}.
If \code{FALSE}, the individuals will be considered affected if the
value is stricly under the \code{threshold}.}

\item{breaks}{Number of breaks to use when using full scale with numeric
values. The same number of breaks will be done for values from affected
individuals and unaffected individuals.}

\item{col_aff}{A character vector with the name of the column to be used
for the affection status.}

\item{add_to_scale}{Boolean defining if the scales need to be added to the
existing scales or if they need to replace the existing scales.}

\item{col_avail}{A character vector with the name of the column to be used
for the availability status.}

\item{reset}{If \code{TRUE} the scale of the specified column will be reset if
already present.}
}
\value{
\subsection{When used with a vector}{

A list of two elements
\itemize{
\item The list containing the filling colors processed and their description
\item The list containing the border colors processed and their description
}
}

\subsection{When used with a Pedigree object}{

The Pedigree object with the \code{affected} and \code{avail} columns
processed accordingly as well as the \code{scales} slot updated.
}
}
\description{
Perform transformation uppon a dataframe given to compute
the colors for the filling and the border of the individuals based
on the affection and availability status.
}
\details{
The colors will be set using the
generate_fill()] and the
\code{\link[=generate_border]{generate_border()}} functions respectively for
the filling and the border.
}
\examples{

generate_colors(
    c("A", "B", "A", "B", NA, "A", "B", "A", "B", NA),
    c(1, 0, 1, 0, NA, 1, 0, 1, 0, NA),
    mods_aff = "A"
)

generate_colors(
    c(10, 0, 5, 7, NA, 6, 2, 1, 3, NA),
    c(1, 0, 1, 0, NA, 1, 0, 1, 0, NA),
    threshold = 3, keep_full_scale = TRUE
)
data("sampleped")
pedi <- Pedigree(sampleped)
pedi <- generate_colors(pedi, "affection", add_to_scale=FALSE)
scales(pedi)
}
\keyword{generate_scales}
