% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSM-filter.R
\name{filterPSMs}
\alias{filterPSMs}
\alias{filterPsmDecoy}
\alias{filterPsmRank}
\alias{filterPsmShared}
\alias{filterPsmFdr}
\title{Filter out unreliable PSMs.}
\usage{
filterPSMs(
  x,
  decoy = psmVariables(x)["decoy"],
  rank = psmVariables(x)["rank"],
  protein = psmVariables(x)["protein"],
  spectrum = psmVariables(x)["spectrum"],
  peptide = psmVariables(x)["peptide"],
  verbose = TRUE
)

filterPsmDecoy(x, decoy = psmVariables(x)["decoy"], verbose = TRUE)

filterPsmRank(x, rank = psmVariables(x)["rank"], verbose = TRUE)

filterPsmShared(
  x,
  protein = psmVariables(x)["protein"],
  peptide = psmVariables(x)["peptide"],
  verbose = TRUE
)

filterPsmFdr(x, FDR = 0.05, fdr = psmVariables(x)["fdr"], verbose = TRUE)
}
\arguments{
\item{x}{An instance of class \code{PSM}.}

\item{decoy}{\code{character(1)} with the column name specifying
whether entries match the decoy database or not. Default is
the \code{decoy} PSM variable as defined in \code{\link[=psmVariables]{psmVariables()}}. The
column should be a \code{logical} and only PSMs holding a \code{FALSE}
are retained. Filtering is ignored if set to \code{NULL} or \code{NA}.}

\item{rank}{\code{character(1)} with the column name holding the rank
of the PSM. Default is the \code{rank} PSM variable as defined in
\code{\link[=psmVariables]{psmVariables()}}. This column should be a \code{numeric} and only
PSMs having rank equal to 1 are retained. Filtering is ignored
if set to \code{NULL} or \code{NA}.}

\item{protein}{\code{character(1)} with the column name holding the
protein (groups) protein. Default is the \code{protein} PSM
variable as defined in \code{\link[=psmVariables]{psmVariables()}}. Filtering is ignored
if set to \code{NULL} or \code{NA}.}

\item{spectrum}{\code{character(1)} with the name of the spectrum
identifier column. Default is the \code{spectrum} PSM variable as
defined in \code{\link[=psmVariables]{psmVariables()}}. Filtering is ignored if set to
\code{NULL} or \code{NA}.}

\item{peptide}{\code{character(1)} with the name of the peptide
identifier column. Default is the \code{peptide} PSM variable as
defined in \code{\link[=psmVariables]{psmVariables()}}. Filtering is ignored if set to
\code{NULL} or \code{NA}.}

\item{verbose}{\code{logical(1)} setting the verbosity flag.}

\item{FDR}{\code{numeric(1)} to be used to filter based on the \code{fdr}
variable. Default is 0.05.}

\item{fdr}{\code{character(1)} variable name that defines that defines
the spectrum FDR (or any similar/relevant metric that can be
used for filtering). This value isn't set by default as it
depends on the search engine and application. Default is \code{NA}.}
}
\value{
A new filtered \code{PSM} object with the same columns as the
input \code{x}.
}
\description{
Functions to filter out PSMs matching. The PSMs should be stored
in a \code{PSM} such as those produced by \code{\link[=PSM]{PSM()}}.

\itemize{
\item \code{filterPsmDecoy()} filters out decoy PSMs, i.e. those annotated
as \code{isDecoy}.
}

\itemize{
\item \code{filterPsmRank()} filters out PSMs of rank > 1.
}

\itemize{
\item \code{filterPsmShared()} filters out shared PSMs, i.e. those that
match multiple proteins.
}

\itemize{
\item \code{filterPsmFdr()} filters out PSMs based on their FDR.
}
}
\examples{
f <- msdata::ident(full.names = TRUE, pattern = "TMT")
basename(f)
id <- PSM(f)
filterPSMs(id)
}
\author{
Laurent Gatto
}
