% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSMatch-package.R
\docType{package}
\name{PSMatch}
\alias{PSMatch-package}
\alias{PSMatch}
\title{PSMatch: Handling and Managing Peptide Spectrum Matches}
\description{
The PSMatch package offers functionality to load, manage and
analyse Peptide Spectrum Matches as generated in mass
spectrometry-based proteomics. The four main objects and concepts
that are proposed in this package are described below, and are
aimed to proteomics practitioners to explore and understand their
identification data better.
}
\section{PSM objects}{


As mentioned in the \code{\link[=PSM]{PSM()}} manual page, The \code{PSM} class is a
simple class to store and manipulate peptide-spectrum matches. The
class encapsulates PSM data as a DataFrame (or more specifically a
\code{DFrame}) with additional lightweight metadata annotation. PSM
objects are typically creatd from XML-based mzID files or
\code{data.frames} imported from spreadsheets. It is then possible to
apply widely used filters (such as removal of decoy hits, PSMs of
rank > 1, ...) as described in \code{\link[=filterPSMs]{filterPSMs()}}.
}

\section{Adjacency matrices}{


PSM data, as produced by all proteomics search engines, is exported
as a table-like structure where PSM are documented along the rows
by variables such as identification scores, peptides sequences,
modifications and the protein which the peptides originate
from. There is always a level of ambiguity in such data, as
peptides can be mapped to mutliple proteins; they are then called
shared peptides, as opposed to unique peptides.

One convenient way to store the relation between peptides and
proteins is as a peptide-by-protein adjacency matrix. Such matrices
can be generated from PSM object or vectors using the
\code{\link[=makeAdjacencyMatrix]{makeAdjacencyMatrix()}} function.

The \code{\link[=describePeptides]{describePeptides()}} and \code{\link[=describeProteins]{describeProteins()}} functions are
also helpful to tally the number of unique and shared peptides and
the number of proteins composed of unique or shared peptides, or a
combination thereof.
}

\section{Connected Components}{


Once we model the peptide-to-protein relations explicitly using an
adjacency matrix, it becomes possible to perform computations on
the proteins that are grouped by the peptides they share. These
groups are mathematically defined as connected components, which
are implemented as \code{\link[=ConnectedComponents]{ConnectedComponents()}} objects.
}

\section{Fragment ions}{


The package also provides functionality to calculate ions produced
by the fragmentation of a peptides (see \code{\link[=calculateFragments]{calculateFragments()}}) and
annotated MS2 \code{\link[Spectra:Spectra]{Spectra::Spectra()}} objects (see \code{\link[=labelFragments]{labelFragments()}}).
}

\section{Vignettes}{


A couple of vignette describe how to several of these concepts
through illustrative use-cases. Use \code{vignette(package = "PSMatch")}
to get a list and open them directly in \code{R} or read them online on
the package's
\href{https://rformassspectrometry.github.io/PSMatch/}{webpage}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/RforMassSpectrometry/PSM}
  \item Report bugs at \url{https://github.com/RforMassSpectrometry/PSM/issues}
}

}
\author{
\strong{Maintainer}: Laurent Gatto \email{laurent.gatto@uclouvain.be} (\href{https://orcid.org/0000-0002-1520-2268}{ORCID})

Authors:
\itemize{
  \item Johannes Rainer \email{Johannes.Rainer@eurac.edu} (\href{https://orcid.org/0000-0002-6977-7147}{ORCID})
  \item Sebastian Gibb \email{mail@sebastiangibb.de} (\href{https://orcid.org/0000-0001-7406-4443}{ORCID})
}

Other contributors:
\itemize{
  \item Samuel Wieczorek \email{samuel.wieczorek@cea.fr} [contributor]
  \item Thomas Burger \email{thomas.burger@cea.fr} [contributor]
  \item Guillaume Deflandre \email{guillaume.deflandre@uclouvain.be} (\href{https://orcid.org/0009-0008-1257-2416}{ORCID}) [contributor]
}

}
