% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationPlots.R
\name{plot_densities}
\alias{plot_densities}
\title{Plot the densities of the normalized data}
\usage{
plot_densities(se, ain = NULL, color_by = NULL, facet_norm = TRUE, ncol = 3)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{facet_norm}{Boolean specifying whether to facet by normalization methods (default TRUE). If FALSE, list of plots of the different normalized data is returned.}

\item{ncol}{Number of columns in plot (for faceting)}
}
\value{
if facet_norm = TRUE, ggplot object, else list of ggplot objects
}
\description{
Plot the densities of the normalized data
}
\examples{
data(tuberculosis_TMT_se)
plot_densities(tuberculosis_TMT_se, ain = NULL, color_by = NULL,
                          facet_norm = TRUE, ncol = 3)
plot_densities(tuberculosis_TMT_se, ain = c("log2", "IRS_on_RobNorm"),
                          color_by = "Label",
              facet_norm = FALSE)

}
