% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEAnalysis.R
\name{apply_thresholds}
\alias{apply_thresholds}
\title{Apply other thresholds to DE results}
\usage{
apply_thresholds(
  de_res,
  logFC = TRUE,
  logFC_up = 1,
  logFC_down = -1,
  p_adj = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{logFC}{Boolean specifying whether to apply a logFC threshold (TRUE) or not (FALSE)}

\item{logFC_up}{Upper log2 fold change threshold (dividing into up regulated)}

\item{logFC_down}{Lower log2 fold change threshold (dividing into down regulated)}

\item{p_adj}{Boolean specifying whether to apply a threshold on adjusted p-values (TRUE) or on raw p-values (FALSE)}

\item{alpha}{Threshold for adjusted p-values or p-values}
}
\value{
data table updating the Change column with the newly applied thresholds
}
\description{
Apply other thresholds to DE results
}
\examples{
data(tuberculosis_TMT_de_res)
de_res <- apply_thresholds(tuberculosis_TMT_de_res, logFC = FALSE,
                           p_adj = TRUE, alpha = 0.01)

}
