% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPOWSC.R
\name{plot_POWSC}
\alias{plot_POWSC}
\title{plot the result use visualization.}
\usage{
plot_POWSC(POWSCobj, Form = c("I", "II"), Cell_Type = c("PW", "Multi"))
}
\arguments{
\item{POWSCobj}{a POWSC object from \code{runPOWSC}}

\item{Form}{choose from "I" or "II".}

\item{Cell_Type}{choose from "PW" or "Multi"}
}
\value{
for multiple comparison cases, return the pheatmap; for the pairwise comparison, return the ggplot object.
}
\description{
plot the result use visualization.
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(12)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
est_Paras = Est2Phase(sce)
sim_size = c(100, 200) # A numeric vector
pow_rslt = runPOWSC(sim_size = sim_size, est_Paras = est_Paras,per_DE=0.05, DE_Method = "MAST", Cell_Type = "PW") # Note, using our previous developed tool SC2P is faster.
plot_POWSC(pow_rslt, Form="II", Cell_Type = "PW") # Alternatively, we can use Form="I")
}
