% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managing_batch_effects.R
\name{percentileofscore}
\alias{percentileofscore}
\title{Percentile score}
\usage{
percentileofscore(df, control.index)
}
\arguments{
\item{df}{A data frame or matrix that contains the microbial variables
to be converted into percentile scores. Samples are in rows and variables
are in columns.}

\item{control.index}{A numeric vector that contains the indices
of control samples (row indices of \code{df}).}
}
\value{
A data frame of percentile scores (between 0 and 1) for each
microbial variable and each sample.
}
\description{
This function converts the relative abundance of microbial variables
(i.e. bacterial taxa) in case (i.e. disease) samples to percentiles of
the corresponding variables in control (i.e. healthy) samples.
It is a built-in function of \code{percentile_norm()}.
}
\examples{
NULL

}
\references{
\insertRef{gibbons2018correcting}{PLSDAbatch}
}
\keyword{internal}
