% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBoptimize.R
\name{PICBoptimize}
\alias{PICBoptimize}
\title{Runs PICBbuild multiple times with provided parameters and returns optimization data frame.}
\usage{
PICBoptimize(
  IN.ALIGNMENTS,
  REFERENCE.GENOME,
  LIBRARY.SIZE = length(IN.ALIGNMENTS$unique) + length(IN.ALIGNMENTS$multi.primary),
  VERBOSITY = 2,
  PROVIDE.INFO.SEEDS.AND.CORES = FALSE,
  SEQ.LEVELS.STYLE = "UCSC",
  ...
)
}
\arguments{
\item{IN.ALIGNMENTS}{list of alignments from PICBload}

\item{REFERENCE.GENOME}{name of genome. For example "BSgenome.Dmelanogaster.UCSC.dm6"}

\item{LIBRARY.SIZE}{number of reads in the library. By default computed as number of unique mapping alignments + number of primary multimapping alignments.}

\item{VERBOSITY}{verbosity level 0/1/2/3. 2 by default.}

\item{PROVIDE.INFO.SEEDS.AND.CORES}{FALSE by default.}

\item{SEQ.LEVELS.STYLE}{naming of chromosomes style. "UCSC" by default.}

\item{...}{rest of the parameters used by PICBbuild and provided as iteratable vectors}
}
\value{
Optimization values dataframe
}
\description{
Runs PICBbuild multiple times with provided parameters and returns optimization data frame.
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
myAlignmentsFromPICBload <- PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSE = FALSE
)

PICBoptimize(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    MIN.UNIQUE.ALIGNMENTS.PER.WINDOW = c(1, 2, 3, 4, 5)
)
}
\author{
Aleksandr Friman
}
