% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBloadfasta.R
\name{PICBloadfasta}
\alias{PICBloadfasta}
\title{Get SeqInfo object from a fasta file}
\usage{
PICBloadfasta(FASTA.NAME = NULL)
}
\arguments{
\item{FASTA.NAME}{path to the fasta file}
}
\value{
SeqInfo object with all chromosome names and lengths from the fasta file
}
\description{
Get SeqInfo object from a fasta file
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)

# create temporary fasta file
chr2L_seq <- BSgenome.Dmelanogaster.UCSC.dm6[["chr2L"]]
chr2L_seq_set <- DNAStringSet(chr2L_seq)
names(chr2L_seq_set) <- "chr2L"
temp_fasta <- tempfile(fileext = ".fasta")
writeXStringSet(chr2L_seq_set, temp_fasta)

myGenome <- PICBloadfasta(FASTA.NAME = temp_fasta)
unlink(temp_fasta)
}
\author{
Aleksandr Friman
}
