% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses,SurvivalExperiment,GeneFuModel-method}
\alias{predictClasses,SurvivalExperiment,GeneFuModel-method}
\title{Use a Gene Signature Based Prediciton Model from the \code{genefu} Package
to Predict Signature Scores for Each Sample.}
\usage{
\S4method{predictClasses}{SurvivalExperiment,GeneFuModel}(object, model, ..., annot = NA)
}
\arguments{
\item{object}{A \code{SurvivalExperiment} to predict classes for.}

\item{model}{A \code{GeneFuModel} object to predict classes with.}

\item{...}{Fall through parameters to \code{genefu::sig.score}.}

\item{annot}{A named parameter with annotations mapping from the gene
identifiers in the genefu model.}
}
\value{
The \code{SurvivalExperiment} passed to the \code{object} argument with
the \code{genefu_score} column added to the objects \code{colData} slot.
}
\description{
Use a Gene Signature Based Prediciton Model from the \code{genefu} Package
to Predict Signature Scores for Each Sample.
}
\details{
A signature score should be interpreted as unit-less continuous risk predictor.
}
