% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-normalize.R
\name{normalize,DFrame-method}
\alias{normalize,DFrame-method}
\title{Normalize a S4 \code{DFrame} Object}
\usage{
\S4method{normalize}{DFrame}(object, MARGIN = 2, FUN = "preprocessCaret", ...)
}
\arguments{
\item{object}{A \code{DFrame} or \code{DataFrame} object to normalize.}

\item{MARGIN}{An \code{integer} indicating if rows (1) or columns (2) should be
normalized. Defaults to 2 for columns.}

\item{FUN}{A function to normalize your data with. Should accept a
rectangular object such as a \code{matrix}, \code{data.frame}, or \code{data.table} and
return an object of the same class with the data normalized using FUN.}

\item{...}{Fall through parameters to FUN. For the default FUN, these are
passed to \code{caret::preProcess} to allow configuration of the normalization
method. Omitting any arguments with the default FUN will scale and center
the data.}
}
\value{
A normalized \code{DFrame} object.
}
\description{
Normalize a S4 \code{DFrame} Object
}
