% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-forestPlot.R
\name{forestPlot,PCOSP_or_ClinicalModel-method}
\alias{forestPlot,PCOSP_or_ClinicalModel-method}
\title{Render a forest plot from the \code{validationStats} slot of a \code{PCOSP} model object.}
\usage{
\S4method{forestPlot}{PCOSP_or_ClinicalModel}(
  object,
  stat,
  groupBy = "mDataType",
  colourBy = "isSummary",
  vline,
  ...,
  xlab,
  ylab,
  transform,
  colours,
  title
)
}
\arguments{
\item{object}{A \code{PCOSP} model which has been validated with \code{validateModel}
and therefore has data in the \code{validationStats} slot.}

\item{stat}{A \code{character} vector specifying a statistic to plot.}

\item{groupBy}{A \code{character} vector with one or more columns in
\code{validationStats} to group by. These will be the facets in your forestplot.}

\item{colourBy}{A \code{character} vector specifying the columns in
\code{validationStats} to colour by.}

\item{vline}{An \code{integer} value on the x-axis to place a dotted vertical
line.}

\item{...}{Force subsequent parameters to be named, not used.}

\item{xlab}{A \code{character} vector specifying the desired x label.
Automatically guesses based on the \code{stat} argument.}

\item{ylab}{A \code{character} vector specifying the desired y label.
Defaults to 'Cohort (P-value)'.}

\item{transform}{The name of a numeric function to transform the statistic
before making the forest plot.}

\item{colours}{A \code{character} vector of colours to pass into
\code{ggplot2::scale_fill_manual}, which modify the colourBy argument.}

\item{title}{A \code{character} vector with a title to add to the plot.}
}
\value{
A \code{ggplot2} object.
}
\description{
Render a forest plot from the \code{validationStats} slot of a \code{PCOSP} model object.
}
\examples{
data(sampleValPCOSPmodel)

# Plot
dIndexForestPlot <- forestPlot(sampleValPCOSPmodel, stat='log_D_index')

}
