% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHpSim.R
\name{calcHpSim}
\alias{calcHpSim}
\title{Compare HP terms based on semantic similarity}
\usage{
calcHpSim(term1, term2, method = c("Resnik"), IC, ancestors)
}
\arguments{
\item{term1}{one of the HP term to compare}

\item{term2}{the other HP term to compare}

\item{method}{the method for computing semantic simalirity
(default: "Resnik" returns the IC of the MICA: Most Informative
common ancestor)}

\item{IC}{a named vector of Information Content by HP term}

\item{ancestors}{a named list of ancestors by HP term}
}
\value{
A numeric value
}
\description{
This function compares 2 HP terms
based on provided Information Content and ancestors
}
\examples{
## Prerequisite
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)

## Compute similarity between different couples of HP terms
data(hp_ancestors, hpDef, package="PCAN")
hp1 <- "HP:0000518"
hp2 <- "HP:0030084"
hp3 <- "HP:0002119"
hp4 <- "HP:0001305"
hpDef[which(hpDef$id \%in\% c(hp1, hp2)), 1:2]
calcHpSim(hp1, hp2, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp3)), 1:2]
calcHpSim(hp2, hp3, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp4)), 1:2]
calcHpSim(hp2, hp4, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp3, hp4)), 1:2]
calcHpSim(hp3, hp4, IC=ic, ancestors=hp_ancestors)
}
\author{
Patrice Godard
}
\seealso{
\code{\link{compareHPSets}}
}

