% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SineOptim.R
\name{SineOptim}
\alias{SineOptim}
\title{Function for searching optimal phase shift}
\usage{
SineOptim(Pairdata)
}
\arguments{
\item{Pairdata}{a sample-by-2 matrix indicating the rescaled expression of two genes/isoforms.
all values should be bettwen [-1, 1].}
}
\value{
Output provides the optimal phi (shift) and its corresponding epsilon^2 (value) of the sine model.
epsilon_{g1,g2}^2 = sum_s [X_{g1,s}^2+X^2_{g2,s}
                          -2X_{g1,s}X_{g2,s} cos(phi_{g1,g2})-sin^2(phi_{g1,g2})]^2
}
\description{
Function for searching optimal phase shift
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
SineOptim(cbind(aa,bb))
}
\author{
Ning Leng
}

