% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{relations_list_to_table}
\alias{relations_list_to_table}
\title{Table from a nested list of ontology relations}
\usage{
relations_list_to_table(relations, direction = NULL)
}
\arguments{
\item{relations}{A nested list of ontology relations (the "relations"
element of the list returned by \code{\link{obo_parser}} in case
its argument `tables` is \code{FALSE}).}

\item{direction}{Override the direction (i.e. child -> parents or parent
-> children). The nested lists produced by functions in the current
package add an attribute "direction" thus no need to pass this value.
If the attribute and the argument are both missing, the column will
be named simply "side2" and it won't be clear whether the relations
point from "term" to "side2" or the other way around. The direction
should be a character vector of length 2 with the values "parents"
and "children".}
}
\value{
The relations converted to a data frame (tibble).
}
\description{
Converting the nested list to a table is a more costly operation, it takes
a few seconds. Best to do it only once, or pass \code{tables = TRUE} to
\code{\link{obo_parser}}, and convert the data frame to list, if you
also need it in list format.
}
\examples{
goslim_url <-
    "http://current.geneontology.org/ontology/subsets/goslim_generic.obo"
path <- tempfile()
curl::curl_fetch_disk(goslim_url, path)
obo <- obo_parser(path, tables = FALSE)
unlink(path)
rel_tbl <- relations_list_to_table(obo$relations)

}
\seealso{
\itemize{
    \item{\code{\link{swap_relations}}}
    \item{\code{\link{relations_table_to_list}}}
    \item{\code{\link{obo_parser}}}
}
}
