% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_lr_network_omnipath}
\alias{nichenet_lr_network_omnipath}
\title{Builds ligand-receptor network for NicheNet using OmniPath}
\usage{
nichenet_lr_network_omnipath(quality_filter_param = list(), ...)
}
\arguments{
\item{quality_filter_param}{List with arguments for \code{
\link{filter_intercell_network}}. It is recommended to check these
parameters and apply some quality filtering. The defaults already
ensure certain  filtering, but you might want more relaxed or
stringent options.}

\item{...}{Passed to \code{\link{import_intercell_network}}}
}
\value{
A network data frame (tibble) with ligand-receptor interactions
    suitable for use with NicheNet.
}
\description{
Retrieves network prior knowledge from OmniPath and provides it in
a format suitable for NicheNet.
This method never downloads the `ligrecextra` dataset because the
ligand-receptor interactions are supposed to come from \code{
\link{nichenet_lr_network_omnipath}}.
}
\examples{
# use only ligand-receptor interactions (not for example ECM-adhesion):
op_lr_network <- nichenet_lr_network_omnipath(ligand_receptor = TRUE)

# use only CellPhoneDB and Guide to Pharmacology:
op_lr_network <- nichenet_lr_network_omnipath(
    resources = c('CellPhoneDB', 'Guide2Pharma')
)

# only interactions where the receiver is a transporter:
op_lr_network <- nichenet_lr_network_omnipath(
    receiver_param = list(parent = 'transporter')
)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_lr_network}}}
    \item{\code{\link{import_intercell_network}}}
}
}
