% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexes_genes.R
\name{complex_genes}
\alias{complex_genes}
\alias{get_complex_genes}
\title{Get all the molecular complexes for a given gene(s)}
\usage{
complex_genes(complexes = complexes(), genes, all_genes = FALSE)
}
\arguments{
\item{complexes}{Data frame of protein complexes (obtained using
\code{\link{complexes}}).}

\item{genes}{Character: search complexes where these genes present.}

\item{all_genes}{Logical: select only complexes where all of the genes
present together. By default complexes where any of the genes can be
found are returned.}
}
\value{
Data frame of complexes
}
\description{
This function returns all the molecular complexes where an input set
of genes participate. User can choose to retrieve every complex where
any of the input genes participate or just retrieve these complexes where
all the genes in input set participate together.
}
\examples{
complexes <- complexes(resources = c("CORUM", "hu.MAP"))
query_genes <- c("LMNA", "BANF1")
complexes_with_query_genes <- complex_genes(complexes, query_genes)

}
\seealso{
\code{\link{complexes}}
}
