% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chalmers_gem.R
\name{chalmers_gem_network}
\alias{chalmers_gem_network}
\title{Chalmers SysBio GEM in the form of gene-metabolite interactions}
\usage{
chalmers_gem_network(
  organism_or_gem = "Human",
  metab_max_degree = 400L,
  protein_ids = c("uniprot", "genesymbol"),
  metabolite_ids = c("hmdb", "kegg")
)
}
\arguments{
\item{organism_or_gem}{Character or integer or list or data frame: either
an organism (taxon) identifier or a list containing the ``reactions``
data frame as it is provided by \code{\link{chalmers_gem}}, or the
reactions data frame itself.
Supported taxons are 9606 (Homo sapiens), 10090 (Mus musculus),
10116 (Rattus norvegicus), 7955 (Danio rerio), 7227 (Drosophila
melanogaster) and 6239 (Caenorhabditis elegans).}

\item{metab_max_degree}{Degree cutoff used to prune metabolites with high
degree assuming they are cofactors (400 by default).}

\item{protein_ids}{Character: translate the protein identifiers to these ID
types. Each ID type results two extra columns in the output, for the "a"
and "b" sides of the interaction, respectively. The default ID type for
proteins is Esembl Gene ID, and by default UniProt IDs and Gene
Symbols are included.}

\item{metabolite_ids}{Character: translate the protein identifiers to these ID
types. Each ID type results two extra columns in the output, for the "a"
and "b" sides of the interaction, respectively. The default ID type for
metabolites is Metabolic Atlas ID, and HMDB IDs and KEGG IDs are included.}
}
\value{
Data frame (tibble) of gene-metabolite interactions.
}
\description{
Processing GEMs from Wang et al., 2021
(\url{https://github.com/SysBioChalmers}) to generate PKN for COSMOS
}
\examples{
gem <- chalmers_gem_network()

}
\references{
Wang H, Robinson JL, Kocabas P, Gustafsson J, Anton M, Cholley
    PE, Huang S, Gobom J, Svensson T, Uhlen M, Zetterberg H, Nielsen J.
    Genome-scale metabolic network reconstruction of model animals as a
    platform for translational research. Proc Natl Acad Sci U S A. 2021 Jul
    27;118(30):e2102344118. doi: \doi{10.1073/pnas.2102344118}.
}
\seealso{
\itemize{
    \item{\code{\link{chalmers_gem}}}
    \item{\code{\link{chalmers_gem_metabolites}}}
    \item{\code{\link{chalmers_gem_reactions}}}
    \item{\code{\link{chalmers_gem_raw}}}
    \item{\code{\link{chalmers_gem_id_mapping_table}}}
    \item{\code{\link{cosmos_pkn}}}
}
}
