% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{kegg_pathways_download}
\alias{kegg_pathways_download}
\title{Download the KEGG Pathways database}
\usage{
kegg_pathways_download(max_expansion = NULL, simplify = FALSE)
}
\arguments{
\item{max_expansion}{Numeric: the maximum number of relations
derived from a single relation record. As one entry might represent
more than one molecular entities, one relation might yield a large
number of relations in the processing. This happens in a combinatorial
way, e.g. if the two entries represent 3 and 4 entities, that results
12 relations. If \code{NULL}, all relations will be expanded.}

\item{simplify}{Logical: remove KEGG's internal identifiers and the
pathway annotations, keep only unique interactions with direction
and effect sign.}
}
\value{
A data frame (tibble) of interactions.
}
\description{
Downloads all pathway diagrams in the KEGG Pathways database in KGML
format and processes the XML to extract the interactions.
}
\examples{
\dontrun{
kegg_pw <- kegg_pathways_download(simplify = TRUE)
kegg_pw
# # A tibble: 6,765 x 6
#    uniprot_source uniprot_target type  effect genesymbol_source
#    <chr>          <chr>          <chr> <chr>  <chr>
#  1 Q03113         Q15283         PPrel activ. GNA12
#  2 Q9Y4G8         P62070         PPrel activ. RAPGEF2
#  3 Q13972         P62070         PPrel activ. RASGRF1
#  4 O95267         P62070         PPrel activ. RASGRP1
#  5 P62834         P15056         PPrel activ. RAP1A
# # . with 6,760 more rows, and 1 more variable: genesymbol_target <chr>
}

}
\seealso{
\itemize{
    \item{\code{\link{kegg_pathway_list}}}
    \item{\code{\link{kegg_process}}}
    \item{\code{\link{kegg_pathway_download}}}
}
}
