% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVESEGtest.R
\name{OVESEGtest}
\alias{OVESEGtest}
\title{OVESEG-test}
\usage{
OVESEGtest(y, group, weights = NULL, alpha = "moderated",
  NumPerm = 999, seed = 111, detail.return = TRUE,
  BPPARAM = bpparam())
}
\arguments{
\item{y}{a numeric matrix containing log-expression or logCPM
(log2-counts per million) values.
Data frame or SummarizedExperiment object will be
internally coerced into a matrix.
Rows correspond to probes and columns to samples.
Missing values are not permitted.}

\item{group}{categorical vector or factor giving group membership of
columns of y. At least two categories need to be presented.}

\item{weights}{optional numeric matrix containing prior weights
for each spot.}

\item{alpha}{parameter specifying within-group variance estimator to be used.
'moderated': empirical Bayes moderated variance estimator as used in
\code{\link[limma]{eBayes}}.
Numeric value: a constant value added to pooled variance estimator
(\eqn{\alpha + \sigma}).
NULL: no estimator; all variances are set to be 1.}

\item{NumPerm}{an integer specifying the number of permutation resamplings
(default 999).}

\item{seed}{an integer seed for the random number generator.}

\item{detail.return}{a logical indicating whether more details about
posterior probability estimation will be returned.}

\item{BPPARAM}{a BiocParallelParam object indicating whether parallelization
should be used for permutation resamplings. The default is bpparam().}
}
\value{
a list containing the following components:
\item{pv.overall}{a vector of p-values calculated by all permutations
regardless of upregulated subtypes.}
\item{pv.oneside}{a vector of subtype-specific p-values calculated
specifically for the upregulated subtype of each probe.}
\item{pv.oneside.max}{subtype-specific p-values when observed test
statistic equal to zero.}
\item{pv.multiside}{pv.oneside*K (K-time comparison correction) and
truncated at 1.}
\item{W}{a matrix of posterior probabilities for each component null
hypothesis given an observed probe. Rows correspond to probes and columns
to one hypothesis.}
\item{label}{a vector of group labels.}
\item{groupOrder}{a matrix with each row being group indexes ordered based
on decreasing expression levels.
Group indexes are positions in \code{label}.}
\item{F.p.value}{a matrix with each column giving p-values corresponding
to F-statistics on certain groups.}
\item{lfdr}{a matrix with each column being local false discovery rates
estimated based on one column of weighted F.p.value matrix.}
\item{fit}{a \code{MArrayLM} fitted model object produced by \code{lmFit}.}
\code{F.p.value}, \code{lfdr} and \code{fit} are returned only when
\code{detail.return} is TRUE.
}
\description{
This function performs OVESEG-test to assess significance of molecular
markers.
}
\details{
OVESEG-test is a statistically-principled method that can detect
tissue/cell-specific marker genes among many subtypes.
OVESEG-test statistics are designed to mathematically match the definition
of molecular markers, and a novel permutation scheme are employed to
estimate the corresponding distribution under null hypotheses where the
expression patterns of non-markers can be highly complex.
}
\examples{
data(RocheBT)
rtest <- OVESEGtest(RocheBT$y, RocheBT$group, NumPerm=99,
                    BPPARAM=BiocParallel::SerialParam())
\dontrun{
#parallel computing
rtest <- OVESEGtest(RocheBT$y, RocheBT$group, NumPerm=99,
                    BPPARAM=BiocParallel::SnowParam())
}
}
