% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNB.R
\name{fit}
\alias{fit}
\alias{fit.OutriderDataSet}
\title{Fit the negative binomial distribution}
\usage{
\method{fit}{OutriderDataSet}(object, BPPARAM = bpparam(), ...)
}
\arguments{
\item{object}{An OutriderDataSet}

\item{BPPARAM}{by default bpparam()}

\item{...}{Currently not used.}
}
\value{
An OutriderDataSet object with the fitted model. Accessible through:
            \code{mcols(ods)[,c('mu', 'theta')]}.
}
\description{
Fit a negative binomial (NB) distribution to the counts per gene
over all samples using, if available, the precomputed control factors.
If no normalization factors are provided only the sizeFactors are used.
}
\examples{
ods <- makeExampleOutriderDataSet()
ods <- estimateSizeFactors(ods)
ods <- fit(ods)

mcols(ods)[1:10,c('mu', 'theta')]

}
