% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_positions.R
\name{upstreamOfPerGroup}
\alias{upstreamOfPerGroup}
\title{Get rest of objects upstream (exclusive)}
\usage{
upstreamOfPerGroup(
  tx,
  upstreamOf,
  allowOutside = TRUE,
  is.circular = all(isCircular(tx) \%in\% TRUE)
)
}
\arguments{
\item{tx}{a \code{\link{GRangesList}},
usually of Transcripts to be changed}

\item{upstreamOf}{a vector of integers, for each group in tx, where
is the the base after the new stop point of last valid exon.}

\item{allowOutside}{a logical (T), can upstreamOf extend outside
range of tx, can set boundary as a false hit, so beware.}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}
}
\value{
a GRangesList of upstream part
}
\description{
Per group get the part upstream of position
upstreamOfPerGroup(tx, startSites(cds, asGR = TRUE))
will return the 5' utrs per transcript, usually used for interesting
parts of the transcripts.
}
\seealso{
Other GRanges: 
\code{\link{assignFirstExonsStartSite}()},
\code{\link{assignLastExonsStopSite}()},
\code{\link{downstreamFromPerGroup}()},
\code{\link{downstreamOfPerGroup}()},
\code{\link{upstreamFromPerGroup}()}
}
\concept{GRanges}
\keyword{internal}
