% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{transcriptWindow1}
\alias{transcriptWindow1}
\title{Meta coverage over all transcripts}
\usage{
transcriptWindow1(
  df,
  outdir = NULL,
  scores = c("sum", "zscore"),
  colors = experiment.colors(df),
  title = "Coverage metaplot",
  windowSize = 100,
  returnPlot = is.null(outdir),
  dfr = NULL,
  idName = "",
  plot.ext = ".pdf",
  type = "ofst",
  drop.zero.dt = drop.zero.dt,
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{outdir}{directory to save to (default: NULL, no saving)}

\item{scores}{scoring function (default: c("sum", "transcriptNormalized")),
see ?coverageScorings for possible scores.}

\item{colors}{Which colors to use, default auto color from function
\code{\link{experiment.colors}}, new color per library type.
Else assign colors yourself.}

\item{title}{title of ggplot}

\item{windowSize}{size of binned windows, minimum of 'wanted_window_size' and
minimum of ranges given. Will inform you if windowSize is < wanted_window_size.}

\item{returnPlot}{return plot from function, default is.null(outdir),
so TRUE if outdir is not defined.}

\item{dfr}{an ORFik \code{\link{experiment}} of RNA-seq to
normalize against. Will add RNA normalized to plot name if this is done.}

\item{idName}{A character ID to add to saved name of plot,
if you make several plots in the same folder,
and same experiment, like splitting transcripts in two groups like
targets / nontargets etc. (default: "")}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
NULL, or ggplot object if returnPlot is TRUE
}
\description{
Given as single window
}
\seealso{
Other experiment plots: 
\code{\link{transcriptWindow}()},
\code{\link{transcriptWindowPer}()}
}
\concept{experiment plots}
\keyword{internal}
