% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{mergeLibs}
\alias{mergeLibs}
\title{Merge and save libraries of experiment}
\usage{
mergeLibs(
  df,
  out_dir = file.path(libFolder(df), "ofst_merged"),
  mode = "all",
  type = "ofst",
  keep_all_scores = TRUE,
  paths = filepath(df, type),
  lib_names_full = bamVarName(df, skip.libtype = FALSE),
  max_splits = 20
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{out_dir}{Ouput directory, default \code{file.path(dirname(df$filepath[1]), "ofst_merged")},
saved as "all.ofst" in this folder if mode is "all". Use a folder called pshifted_merged, for
default Ribo-seq ofst files.}

\item{mode}{character, default "all". Merge all or "rep" for collapsing replicates only, or
"lib" for collapsing all per library type.}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{keep_all_scores}{logical, default TRUE, keep all library scores in the merged file. These
score columns are named the libraries full name from \code{bamVarName(df)}.}

\item{paths}{character vector, the filpaths to use,
default \code{filepath(df, type, only_unique_mappers = only_unique_mappers)}.
Change type argument if not what is wanted.
If that is not enough, then you can also update this argument.
But be careful about using this directly.}

\item{lib_names_full}{character vector, default: bamVarName(df, skip.libtype = FALSE).
Name to assign to single libraries inside merged file, only kept if mode != "all"}

\item{max_splits}{integer, default 20. If number of rows to merge > 2^31,
how many times can you allow split merging to try to "rescue" the merging
process?}
}
\value{
NULL, files saved to disc. A data.table with a score column that now contains the sum
of scores per merge setting.
}
\description{
Aggregate count of reads (from the "score" column) by making a merged library.
Only allowed for .ofst files!
}
\examples{
df2 <- ORFik.template.experiment()
df2 <- df2[df2$libtype == "RFP",]
# Merge all
mergeLibs(df2, tempdir(), mode = "all", type = "default")
# Read as GRanges with mcols
fimport(file.path(tempdir(), "all.ofst"))
# Only keep total score, Read as direct fst data.table
mergeLibs(df2, tempdir(), mode = "all", type = "default", keep_all_scores = FALSE)
fst::read_fst(file.path(tempdir(), "all.ofst"))
# Collapse replicates
mergeLibs(df2, tempdir(), mode = "rep", type = "default")
paths <- file.path(tempdir(), paste0("RFP_", c("Mutant", "WT"), ".ofst"))
lapply(paths, fimport)
# Collapse by lib types (same as "all" in this case)
#mergeLibs(df2, tempdir(), mode = "lib", type = "default")
}
