% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_format_conversion.R
\name{convert_to_bigWig}
\alias{convert_to_bigWig}
\title{Convert to BigWig}
\usage{
convert_to_bigWig(
  df,
  in_files = filepath(df, "pshifted"),
  out_dir = file.path(libFolder(df), "bigwig"),
  split.by.strand = TRUE,
  split.by.readlength = FALSE,
  seq_info = seqinfo(df),
  weight = "score",
  is_pre_collapsed = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}, or NULL is allowed if
both in_files and out_dir is specified manually.}

\item{in_files}{paths to input files, default pshifted files:
\code{filepath(df, "pshifted")} in ofst format}

\item{out_dir}{paths to output files, default
\code{file.path(libFolder(df), "bigwig")}.}

\item{split.by.strand}{logical, default TRUE, split into forward and reverse
strand RleList inside covRle object.}

\item{split.by.readlength}{logical, default FALSE, split into files
for each readlength, defined by readWidths(x) for each file.}

\item{seq_info}{SeqInfo object, default \code{seqinfo(findFa(df))}}

\item{weight}{integer, numeric or single length character. Default "score".
Use score column in loaded in_files.}

\item{is_pre_collapsed}{logical, default FALSE. Have you already
collapsed reads with collapse.by.scores,
so each positions is only in 1 GRanges object with
a score column per readlength?
Set to TRUE, only if you are sure, will give a speedup.}

\item{verbose}{logical, default TRUE, message about library output status.}
}
\value{
invisible(NULL), files saved to disc
}
\description{
Convert to BigWig
}
\examples{
df <- ORFik.template.experiment()[10,]
## Usually do default folder, here we use tmpdir
folder_to_save <- file.path(tempdir(), "bigwig")
convert_to_bigWig(df, out_dir = folder_to_save)
fimport(file.path(folder_to_save, c("RFP_Mutant_rep2_forward.bigWig",
 "RFP_Mutant_rep2_reverse.bigWig")))
}
\seealso{
Other lib_converters: 
\code{\link{convertLibs}()},
\code{\link{convert_bam_to_ofst}()},
\code{\link{convert_to_covRle}()},
\code{\link{convert_to_covRleList}()}
}
\concept{lib_converters}
