% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq_helpers.R
\name{collapse.fastq}
\alias{collapse.fastq}
\title{Very fast fastq/fasta collapser}
\usage{
collapse.fastq(
  files,
  outdir = file.path(dirname(files[1]), "collapsed"),
  header.out.format = "ribotoolkit",
  compress = FALSE,
  prefix = "collapsed_"
)
}
\arguments{
\item{files}{paths to fasta / fastq files to collapse. I tries to detect format per file,
if file does not have .fastq, .fastq.gz, .fq or fq.gz extensions, it will be treated
as a .fasta file format.}

\item{outdir}{outdir to save files, default:
\code{file.path(dirname(files[1]), "collapsed")}.
Inside same folder as input files, then create subfolder "collapsed", and add a prefix
of "collapsed_" to the output names in that folder.}

\item{header.out.format}{character, default "ribotoolkit", else must be "fastx".
How the read header of the output fasta should be formated: ribotoolkit: ">seq1_x55",
sequence 1 has 55 duplicated reads collapsed.
fastx: ">1-55", sequence 1 has 55 duplicated reads collapsed}

\item{compress}{logical, default FALSE}

\item{prefix}{character, default "collapsed_"
Prefix to name of output file.}
}
\value{
invisible(NULL), files saved to disc in fasta format.
}
\description{
For each unique read in the file, collapse into 1 and state in the fasta header
how many reads existed of that type. This is done after trimming usually, works
best for reads < 50 read length. Not so effective for 150 bp length mRNA-seq etc.
}
\examples{

seqs <- rep(c("AAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "GGGGGGGGGGGGGGGGGGGG"), times = c(2,3))
fastq.folder <- tempfile()
dir.create(fastq.folder)
fastq.file <- file.path(fastq.folder, "test.fasta")
writeXStringSet(DNAStringSet(seqs), filepath = fastq.file)
infiles <- dir(fastq.folder, "fasta|fastq", full.names = TRUE)
collapse.fastq(infiles)
readDNAStringSet(file.path(fastq.folder, "collapsed", "collapsed_test.fasta"))
# You see names says x3 of read 1 (GGGG...) and x2 of read 2 (AAAA....)
}
