% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uORF_helpers.R
\name{addCdsOnLeaderEnds}
\alias{addCdsOnLeaderEnds}
\title{Extends leaders downstream}
\usage{
addCdsOnLeaderEnds(fiveUTRs, cds, onlyFirstExon = FALSE)
}
\arguments{
\item{fiveUTRs}{The 5' leader sequences as GRangesList}

\item{cds}{If you want to extend 5' leaders downstream,
to catch uorfs going into cds, include it.}

\item{onlyFirstExon}{logical (F), include whole cds or only first exons.}
}
\value{
a GRangesList of cds exons added to ends
}
\description{
When finding uORFs, often you want to allow them to end inside the cds.
}
\details{
This is a simple way to do that
}
\seealso{
Other uorfs: 
\code{\link{filterUORFs}()},
\code{\link{removeORFsWithSameStartAsCDS}()},
\code{\link{removeORFsWithSameStopAsCDS}()},
\code{\link{removeORFsWithStartInsideCDS}()},
\code{\link{removeORFsWithinCDS}()},
\code{\link{uORFSearchSpace}()}
}
\concept{uorfs}
\keyword{internal}
