\name{sigxy.plot}	
\alias{sigxy.plot} 
\title{Visualisation of significance tests for spatial bias}
\description{This function produces a 2D-plot visualizing the significance
             of spatial bias.}

\usage{sigxy.plot(Sp,Sn,color.lim=c(-3,3),...) }
\arguments{\item{Sp}{matrix of false discovery rates or p-values  for positive deviation of 
                 \eqn{\bar{M}}{median/mean of \code{M}}
		 as produced by \code{fdrspatial} or \code{p.spatial}}
      \item{Sn}{matrix of false discovery rate or p-values for negative deviation of \eqn{\bar{M}}{median/mean of \code{M}}
                as produced by \code{fdrspatial} or \code{p.spatial}}
      \item{color.lim}{limits of color range for plotting vector corresponding to log10(\code{pS}) and log10(\code{nS})}
      \item{...}{Further optional graphical parameter for the \code{image} function generating the MXY plot}
}
\details{The function \code{sigxy.plot} produces a 2d-plot presenting the significance (\code{pS},\code{nS})
         generated by \code{fdrint} or \code{p.spatial}. 
         The significance \code{Sp} for positive \eqn{\bar{M}}{median/mean of \code{M}} of 
         spatial spot  neighbourhoods are presented by red colour; the significance(\code{Sn}) for negative 
         \eqn{\bar{M}}{median/mean of \code{M}} of 
         spatial spot neighbourhoods are presented by green colour.}

\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{colorbar.sig}}, \code{\link{fdr.spatial}},  \code{\link{p.spatial}}, \code{\link{image}},
                \code{\link{p.spatial}}}
\examples{

# To run these examples, "un-comment" them!
#
# LOADING DATA
# data(sw)
#
# M <- v2m(maM(sw)[,1],Ngc=maNgc(sw),Ngr=maNgr(sw),
#                Nsc=maNsc(sw),Nsr=maNsr(sw),main="MXY plot of SW-array 1")
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# This can take a while! For testing, you may choose a smaller N.
# FDR <- fdr.spatial(M,delta=2,N=100,av="median",edgeNA=TRUE)
# sigxy.plot(FDR$FDRp,FDR$FDRn,color.lim=c(-5,5),main="FDR")
# 
# LOADING NORMALISED DATA
# data(sw.olin)
# M <- v2m(maM(sw.olin)[,1],Ngc=maNgc(sw.olin),Ngr=maNgr(sw.olin),
#                Nsc=maNsc(sw.olin),Nsr=maNsr(sw.olin),main="MXY plot of SW-array 1")
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# FDR <- fdr.spatial(M,delta=2,N=100,av="median",edgeNA=TRUE)
# VISUALISATION OF RESULTS
# sigxy.plot(FDR$FDRp,FDR$FDRn,color.lim=c(-5,5),main="FDR")
#
#
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS 
# P <- p.spatial(M,delta=2,N=-1,av="median",p.adjust.method="holm")
# VISUALISATION OF RESULTS
# sigxy.plot(P$Pp,P$Pn,color.lim=c(-5,5),main="FDR")

}

\keyword{hplot}


