\name{p.int}
\alias{p.int} 
\title{Calculates significance of  intensity-dependent bias}	
\description{This function assesses the significance of intensity-dependent bias.  This is 
achieved by comparing the observed average values of logged fold-changes within an intensity neighbourhood
with an empirical distribution generated by permutation tests. The significance is given
by (adjusted) p-values.}
\usage{p.int(A,M,delta=50,N=-1,av="median",p.adjust.method="none")}
\arguments{\item{A}{vector of average logged spot intensity}
           \item{M}{vector of logged fold changes}
           \item{delta}{integer determining the size of the neighbourhood (\code{2 * delta+1}).}
           \item{N}{number of random samples (of size \code{2 * delta+1}) used for the 
                 generation of empirical distribution. If N is negative, 
                 the number of samples 100 times the length of \code{A}.  }
           \item{av}{averaging of \code{M} within neighbourhood by \emph{mean} or \emph{median} (default)}
           \item{p.adjust.method}{method for adjusting p-values due to multiple testing regime. The available
                 methods are \dQuote{none}, \dQuote{bonferroni},  \dQuote{holm}, \dQuote{hochberg},
                 \dQuote{hommel} and \dQuote{fdr}.  See also \code{\link{p.adjust}}} }


\details{The function \code{p.int} assesses the significance of  intensity-dependent bias using a permutation test.
           The null hypothesis states the independence of A and M. To test if \code{M} depends on \code{A}, 
           spots are ordered with respect to A. This defines a neighbourhood of spots with similar A for each spot. 
           Next, the  test statistic is the  \emph{median} or \emph{mean} of \code{M}
            within
           a spot's intensity neighbourhood of chosen size (\code{2 *delta+1}). The empirical distribution of the 
           this statistic is then generated based on \code{N} random  samples (with replacement).
           (Note that sampling without replacement is used for  \code{fdr.int}. Also note, that different meaning of argument \code{N}
            in \code{p.int} and \code{fdr.int}. The argument \code{N} in \code{p.int} is the number fo independent samples (of size  \code{2 *delta+1})
           derived from the original distribution. The argument   \code{N} in \code{fdr.int} states how many times the original distribution 
  is randomised and the permutated distribution is used for generating the empirical distribution.)   
           Comparing this empirical distribution of \eqn{\bar{M}}{median/mean of \code{M}}
            with the observed distribution of \eqn{\bar{M}}{median/mean of \code{M}},
            the independence of \code{M} and \code{A}
           is assessed. If \code{M} is independent of \code{A}, the empirical distribution 
           of \eqn{\bar{M}}{median/mean of \code{M}} can be  expected to be symmetrically 
            distributed around its mean value. To assess the significance of observing positive deviations of 
          the p-values are used. It indicates the expected proportion of neighbourhoods with larger 
           \eqn{\bar{M}}{median/mean of \code{M}} than the actual one based on the empirical distribution of 
           \eqn{\bar{M}}{median/mean of \code{M}}. The minimal p-value is set to  \code{1/N}. 
            Correspondingly, the significance
          of observing negative deviations of \eqn{\bar{M}}{median/mean of \code{M}} can be determined.
          Since this assessment of significance involves multiple testing, an adjustment of the p-values might be advisable.}
\value{A list of vector containing the p-values for positive  (\code{Pp}) and negative (\code{Pn})  deviations of
       \eqn{\bar{M}}{median/mean of \code{M}} of the spot's neighbourhood is produced. Values corresponding to  spots 
       within an interval of \code{delta} at the lower or upper end of the \code{A}-scale are set to \code{NA}.  }
\note{The same functionality but with our input and output formats is offered by \code{\link{p.int2}}}
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{p.int2}},\code{\link{fdr.int}}, \code{\link{sigint.plot}}, \code{\link{p.adjust}}}
\examples{

# To run these examples, "un-comment" them!
#
# LOADING DATA NOT-NORMALISED
# data(sw)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
#  For this illustration, N was chosen rather small. For "real" analysis, it should be larger.
# P <- p.int(maA(sw)[,1],maM(sw)[,1],delta=50,N=10000,av="median",p.adjust.method="none")
# VISUALISATION OF RESULTS
# sigint.plot(maA(sw)[,1],maM(sw)[,1],Sp=P$Pp,Sn=P$Pn,c(-5,-5))

# LOADING NORMALISED DATA
# data(sw.olin)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS 
# P <- p.int(maA(sw.olin)[,1],maM(sw.olin)[,1],delta=50,N=10000,av="median",p.adjust.method="none")
# VISUALISATION OF RESULTS
# sigint.plot(maA(sw.olin)[,1],maM(sw.olin)[,1],Sp=P$Pp,Sn=P$Pn,c(-5,-5))

}
\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




