% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extendGRanges}
\alias{extendGRanges}
\title{Extend a GRanges object}
\usage{
extendGRanges(OGREDataSet, name, upstream = 0, downstream = 0)
}
\arguments{
\item{OGREDataSet}{An OGREDataSet}

\item{name}{\code{character} Name of the GRanges object for extending}

\item{upstream}{\code{int} (positive or negative number)}

\item{downstream}{\code{int} (positive or negative number)}
}
\value{
OGREDataSet
}
\description{
Extend(shrink) ranges of a GRanges object.
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
#extend range by shifting start 100 bp in upstream direction
myOGRE <- extendGRanges(myOGRE,"genes",upstream=100)
#shrinking range by shifting end 100 bp in upstream direction
myOGRE <- extendGRanges(myOGRE,"genes",downstream=-100)
#shrinking range by shifting from both sides to the center
myOGRE <- extendGRanges(myOGRE,"genes",upstream=-10,downstream=-10)
}
