% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeResults.R
\name{analyzeNormalizations}
\alias{analyzeNormalizations}
\title{Calculate measures for normalization results}
\usage{
analyzeNormalizations(nr, categoricalAnova = FALSE)
}
\arguments{
\item{nr}{Normalyzer results object with calculated results.}

\item{categoricalAnova}{Whether categorical or numerical (ordered) ANOVA
should be calculated.}
}
\value{
Normalyzer results with attached evaluation results object.
}
\description{
This function prepares an NormalyzerEvaluationResults object containing
the evaluation measures CV (coefficient of variance), MAD (median absolute
deviation), average variance, significance measures (ANOVA between
condition groups) and correlation between replicates.
}
\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
normResults <- normMethods(normObj)
normResultsWithEval <- analyzeNormalizations(normResults)
}
