% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.R
\name{KeggEnrichment}
\alias{KeggEnrichment}
\title{KEGG pathway enrichment}
\usage{
KeggEnrichment(
  genes,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3"),
  pCut = 0.05,
  pAdjCut = 0.05,
  pAdjust = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"),
  min = 5,
  gmtFile = "",
  isSymbol = "",
  isGeneEnrich = ""
)
}
\arguments{
\item{genes}{Input genes}

\item{org_assembly}{Genome assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}

\item{pCut}{Threshold value for the pvalue. Default value is 0.05}

\item{pAdjCut}{Cutoff value for the adjusted p-values using one of given
method. Default value is 0.05.}

\item{pAdjust}{Methods of the adjusted p-values. Possible methods are
"holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none"}

\item{min}{Minimum number of genes that are required for enrichment.
By default, it is set to 5.}

\item{gmtFile}{File path of the gmt file}

\item{isSymbol}{Boolean value that controls the gene formats. If it is TRUE,
gene format of the gmt file should be symbol. Otherwise, gene format
must be ENTREZ ID.}

\item{isGeneEnrich}{Boolean value whether gene enrichment should be
performed}
}
\value{
KEGG pathway enrichment results
}
\description{
KEGG pathway enrichment
}
\examples{
\dontrun{
subsetGene <- breastmRNA[1:30,]

br_enr<-KeggEnrichment(genes = subsetGene,
                       org_assembly='hg19')
}

}
