% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{wkde2d}
\alias{wkde2d}
\title{Weighted 2D kernel density estimation}
\usage{
wkde2d(x, y, w, h, adjust = 1, n = 100, lims = c(range(x), range(y)))
}
\arguments{
\item{x}{Dimension 1}

\item{y}{Dimension 2}

\item{w}{Weight variable}

\item{h}{vector of bandwidths for x and y directions.
Defaults to normal reference bandwidth (ks::hpi).
A scalar value will be taken to apply to both directions.}

\item{adjust}{Bandwidth adjustment}

\item{n}{Number of grid points in each direction. Can be scalar or a
length-2 integer vector.}

\item{lims}{The limits of the rectangle covered by the grid as
c(xl, xu, yl, yu).}
}
\value{
A list of three components.
\itemize{
\item \code{x, y} The x and y coordinates of the grid points, vectors of
length n.
\item \code{z} An n[1] by n[2] matrix of the weighted estimated density:
rows correspond to the value of x, columns to the value of y.
}
}
\description{
Weighted 2D kernel density estimation
}
\examples{

set.seed(1)
x <- rnorm(100)

set.seed(2)
y <- rnorm(100)

set.seed(3)
w <- sample(c(0, 1), 100, replace = TRUE)

dens <- Nebulosa:::wkde2d(x, y, w)
}
\author{
Jose Alquicira-Hernandez
}
