% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsseq_to_edger.R
\name{methy_to_edger}
\alias{methy_to_edger}
\title{Convert NanoMethResult object to edgeR methylation matrix}
\usage{
methy_to_edger(methy, regions = NULL, out_folder = tempdir(), verbose = TRUE)
}
\arguments{
\item{methy}{the NanoMethResult object or path to the methylation tabix file.}

\item{regions}{the regions to calculate log-methylation ratios over. If left
NULL, ratios will be calculated per site.}

\item{out_folder}{the folder to store intermediate files. One file is created
for each sample and contains columns "chr", "pos", "total" and
"methylated".}

\item{verbose}{TRUE if progress messages are to be printed}
}
\value{
a matrix compatible with the edgeR differential methylation pipeline
}
\description{
Convert NanoMethResult object to edgeR methylation matrix
}
\examples{
nmr <- load_example_nanomethresult()
edger_mat <- methy_to_edger(nmr)

}
