% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidak.R
\name{sidak}
\alias{sidak}
\title{Correct p-values for multiple comparisons}
\usage{
sidak(vecP)
}
\arguments{
\item{vecP}{vector of p-values}
}
\value{
adjusted p-values
}
\description{
Correct p-values for multiple comparisons
}
\details{
This function corrects a vector of probabilities for multiple testing
using the Bonferroni (1935) and Sidak (1967) corrections.
References: Bonferroni (1935), Sidak (1967), Wright (1992).
Bonferroni, C. E. 1935. Il calcolo delle assicurazioni su gruppi di teste.
Pp. 13-60 in: Studi in onore del Professore Salvatore Ortu Carboni. Roma.
Sidak, Z. 1967. Rectangular confidence regions for the means of multivariate
normal distributions. Journal of the American Statistical Association 62:626-633.
Wright, S. P. 1992. Adjusted P-values for simultaneous inference.
Biometrics 48: 1005-1013.
Pierre Legendre, May 2007
}
\examples{
p_values <- c(0.01, 0.04, 0.03, 0.08, 0.05)
adjusted_p <- sidak(p_values)
adjusted_p$SidakP
}
