% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectra.R
\name{plot_spectra}
\alias{plot_spectra}
\title{Plot spectra}
\usage{
plot_spectra(
  mf_data,
  group_col = "sample",
  subtype_resolution = "base_6",
  response = "proportion",
  mf_type = "min",
  group_order = "none",
  group_order_input = NULL,
  dist = "cosine",
  cluster_method = "ward.D",
  custom_palette = NULL,
  x_lab = NULL,
  y_lab = NULL,
  rotate_xlabs = FALSE
)
}
\arguments{
\item{mf_data}{A data frame containing the mutation frequency data at the
desired subtype resolution. This is obtained using the 'calculate_mf'
function with subtype_resolution set to the desired resolution.
Data must include a column containing the group_col,
a column containing the mutation subtypes, a column containing the desired
response variable (mf, proportion, sum) for the desired mf_type
(min or max), and if applicable, a column containing the variable by which
to order the samples/groups.}

\item{group_col}{The name of the column(s) in the mf data that contains the
sample/group names. This will generally be the same values used for the
cols_to_group argument in the calculate_mf function. However, you may
also use groups that are at a higher level of the aggregation in mf_data.}

\item{subtype_resolution}{The subtype resolution of the mf data.
Options are \code{base_6}, \code{base_12}, \code{base_96}, \code{base_192}, or \code{type}.
Default is \code{base_6}.}

\item{response}{The desired response variable to be plotted. Options are
mf, proportion, or sum. Default is \code{proportion}. Your mf_data must contain
columns with the name of your desired response: \code{mf_min}, \code{mf_max},
\code{proportion_min}, \code{proportion_max}, \code{sum_min}, and \code{sum_max}.}

\item{mf_type}{The mutation counting method to use. Options are min or max.
Default is \code{min}.}

\item{group_order}{The method for ordering the samples within the plot.
Options include:
\itemize{
\item \code{none}: No ordering is performed. Default.
\item \code{smart}: Groups are automatically ordered based on the group names
(alphabetical, numerical)
\item \code{arranged}: Groups are ordered based on one or more factor column(s)
in mf_data. Column names are passed to the function using the
\code{group_order_input}.
\item \code{custom}: Groups are ordered based on a custom vector of group
names. The custom vector is passed to the function using the
\code{group_order_input}.
\item \code{clustered}: Groups are ordered based on hierarchical clustering. The
dissimilarity matrix can be specified using the \code{dist} argument. The
agglomeration method can be specified using the \code{cluster_method} argument.
}}

\item{group_order_input}{A character vector specifying details for the
group order method. If \code{group_order} is \code{arranged}, \code{group_order_input}
should contain the column name(s) to be used for ordering the samples. If
\code{group_order} is \code{custom}, \code{group_order_input} should contain the custom
vector of group names.}

\item{dist}{The dissimilarity matrix for hierarchical clustering. Options
are \code{cosine}, \code{euclidean}, \code{maximum}, \code{manhattan}, \code{canberra}, \code{binary} or
\code{minkowski}. The default is \code{cosine}. See \link[stats]{dist} for details.}

\item{cluster_method}{The agglomeration method for hierarchical clustering.
Options are \code{ward.D}, \code{ward.D2}, \code{single}, \code{complete}, \code{average} (= UPGMA),
\code{mcquitty} (= WPGMA), \code{median} (= WPGMC) or \code{centroid} (= UPGMC). The default
is \code{Ward.D}. See \link[stats]{hclust} for details.}

\item{custom_palette}{A named vector of colors to be used for the mutation
subtypes. The names of the vector should correspond to the mutation subtypes
in the data. Alternatively, you can specify a color palette from the
RColorBrewer package. See \code{\link[RColorBrewer]{brewer.pal}} for palette
options. You may visualize the palettes at the ColorBrewer website:
\url{https://colorbrewer2.org/}. Default is \code{NULL}.}

\item{x_lab}{The label for the x-axis. Default is the value of \code{group_col}.}

\item{y_lab}{The label for the y-axis. Default is the value of \code{response_col}.}

\item{rotate_xlabs}{A logical value indicating whether the x-axis labels
should be rotated 90 degrees. Default is FALSE.}
}
\value{
A ggplot object representing the mutation spectra plot.
}
\description{
Given mf data, construct a plot displaying the
mutation subtypes observed in a cohort.
}
\examples{
# Example data consists of 24 mouse bone marrow DNA samples imported
# using import_mut_data() and filtered with filter_mut. Filtered
# mutation data is available in the MutSeqRData ExperimentHub package:
# eh <- ExperimentHub::ExperimentHub()
# Example 1: Visualized the 6-base mutation proportions per dose group.
# Data was summarized per dose_group using:
# calculate_mf(mutation_data = eh[["EH9861"]],
#              cols_to_group = "dose_group",
#              subtype_resolution = "base_6")
# Load the example data
mf_example <- readRDS(system.file("extdata", "Example_files", "mf_data_6.rds",
  package = "MutSeqR"
))
# Convert dose_group to a factor with the desired order.
mf_example$dose_group <- factor(mf_example$dose_group,
  levels = c("Control", "Low", "Medium", "High")
)
# Plot the mutation spectra
plot <- plot_spectra(
  mf_data = mf_example,
  group_col = "dose_group",
  subtype_resolution = "base_6",
  response = "proportion",
  group_order = "arranged",
  group_order_input = "dose_group"
)

# Example 2: plot the proportion of 6-based mutation subtypes
# for each sample, ordered by hierarchical clustering:
# Data was summarized per dose_group using:
# calculate_mf(mutation_data = eh[["EH9861"]],
#              cols_to_group = "sample",
#              subtype_resolution = "base_6")
# Load the example data
mf_example2 <- readRDS(system.file("extdata", "Example_files", "mf_data_6_sample.rds",
  package = "MutSeqR"
))
plot <- plot_spectra(
  mf_data = mf_example2,
  group_col = "sample",
  subtype_resolution = "base_6",
  response = "proportion",
  group_order = "clustered"
)
}
