% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_helpers.R
\name{import_regions_metadata}
\alias{import_regions_metadata}
\title{Join Regions Metadata}
\usage{
import_regions_metadata(
  mutation_granges,
  regions,
  rg_sep,
  is_0_based_rg,
  padding
)
}
\arguments{
\item{mutation_granges}{A data frame containing mutation data.}

\item{regions}{The path to the file containing the regions metadata.
Alternatively, a data frame can be provided directly.}

\item{rg_sep}{The separator used in the regions metadata file.
Default is tab (\verb{\\t}).}

\item{is_0_based_rg}{A logical value indicating whether the regions file is
0-based (TRUE) or 1-based (FALSE). Default is FALSE.}

\item{padding}{An integer value indicating the number of base pairs to pad
the regions on either side. Default is 0.}
}
\value{
A GRanges object that combines the mutation data with the regions
metadata.
}
\description{
This function imports the regions metadata and joins it with
the mutation data.
}
