% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFUZZanalysis.R
\name{MFUZZanalysis}
\alias{MFUZZanalysis}
\title{Clustering of temporal patterns (Main function).}
\usage{
MFUZZanalysis(
  SEresNorm,
  DATAnorm = TRUE,
  DataNumberCluster = NULL,
  Method = "hcpc",
  Max.clust = 6,
  Membership = 0.5,
  Min.std = 0.1,
  Plot.Mfuzz = TRUE,
  path.result = NULL,
  Name.folder.mfuzz = NULL
)
}
\arguments{
\item{SEresNorm}{Results of the function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{DATAnorm}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
\code{TRUE} means the function uses the normalized data.
\code{FALSE} means the function uses the raw counts data.}

\item{DataNumberCluster}{Data.frame or \code{NULL}. \code{NULL} as default.
If \code{DataNumberCluster} is a data.frame where the first column contains
the name of the biological conditions and the second the number of cluster
selected for each biological condition.
If \code{DataNumberCluster=NULL}, a number of clusters will be automatically
computed for each biological condition
(see \code{\link[=MFUZZclustersNumber]{MFUZZclustersNumber()}}).}

\item{Method}{"kmeans" or "hcpc". The method used for selecting the number
of cluster to be used for the temporal cluster analysis
(see \code{Details}).
Only used if \code{DataNumberCluster} is not \code{NULL}.}

\item{Max.clust}{Integer strictly superior to 1 indicating the maximum
number of clusters.
\code{Max.clust} will be used only if \code{DataNumberCluster=NULL}}

\item{Membership}{Numeric value between 0 and 1.
For each cluster, genes with membership values below the threshold
\code{Membership} will not be displayed.
The membership values correspond to the probability of gene to belong
to each cluster.}

\item{Min.std}{Numeric positive value.
All genes where their standard deviations are smaller than the threshold
\code{Min.std} will be excluded.}

\item{Plot.Mfuzz}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}. Path to save all results.
If \code{path.result} contains a sub folder entitled
"1_UnsupervisedAnalysis_\code{Name.folder.mfuzz}" and a sub sub folder,
"1-4_MFUZZanalysis_\code{Name.folder.mfuzz}"
all results will be saved in the sub folder
"1_UnsupervisedAnalysis_\code{Name.folder.mfuzz}/
1-4_MFUZZanalysis_\code{Name.folder.mfuzz}.
Otherwise, a sub folder entitled
"1_UnsupervisedAnalysis_\code{Name.folder.mfuzz}" and/or a sub sub folder
"1-4_MFUZZanalysis_\code{Name.folder.mfuzz}"
will be created in \code{path.result} and all results will be saved in
"1_UnsupervisedAnalysis_\code{Name.folder.mfuzz}/
1-4_MFUZZanalysis_\code{Name.folder.mfuzz}".
If \code{NULL}, the results will not be saved in a folder.
\code{NULL} as default.}

\item{Name.folder.mfuzz}{Character or \code{NULL}.
If \code{Name.folder.mfuzz} is a character, the folder and sub folder names
which will contain the PCA graphs will respectively be
"1_UnsupervisedAnalysis_\code{Name.folder.mfuzz}" and
"1-4_MFUZZanalysis_\code{Name.folder.mfuzz}".
Otherwise, the folder and sub folder names will respectively be
"1_UnsupervisedAnalysis" and "1-4_MFUZZanalysis".}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresNorm} with the different elements below
(saved in the metadata \code{Results[[1]][[4]]} of \code{SEresNorm})
\itemize{
\item the final data used for the \code{Mfuzz} analysis (see \code{Details}).
\item the cluster associated to each gene.
\item plots generated by
\code{\link[=MFUZZclustersNumber]{MFUZZclustersNumber()}} and
\code{\link[Mfuzz:mfuzz.plot2]{Mfuzz::mfuzz.plot2()}}
for each biological condition.
}
}
\description{
The function performs a soft clustering of temporal patterns
based on the fuzzy c-means algorithm using the R package \code{Mfuzz}.
}
\details{
All results are built from the results of our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.

The \code{Mfuzz} package works with datasets where rows correspond to genes
and columns correspond to times.
If \code{RawCounts} (input of our function
\code{\link[=DATAprepSE]{DATAprepSE()}})
contains several replicates per time,
the algorithm computes the mean of replicates for each gene before using
\code{\link[Mfuzz:mfuzz]{Mfuzz::mfuzz()}}.
When there are several biological conditions, the algorithm realizes the
\code{\link[Mfuzz:mfuzz]{Mfuzz::mfuzz()}}
analysis for each biological condition.
}
\examples{
## Data simulation
set.seed(33)
DATAclustSIM <- matrix(rnorm(12*10*3, sd=0.2,
                             mean=rep(c(rep(c(1, 6, 9, 4, 3, 1,
                                              6.5, 0.7, 10), times=2),
                                        rep(c(2, 3.6, 3.7, 5, 7.9, 8,
                                              7.5, 3.5, 3.4), times=2)),
                                      each=10)),
                       nrow=30, ncol=12)
DATAclustSIM <- floor(DATAclustSIM*100)
##
colnames(DATAclustSIM) <- c("G1_t0_r1", "G1_t1_r1", "G1_t2_r1",
                            "G1_t0_r2", "G1_t1_r2", "G1_t2_r2",
                            "G2_t0_r3", "G2_t1_r3", "G2_t2_r3",
                            "G2_t0_r4", "G2_t1_r4", "G2_t2_r4")
##------------------------------------------------------------------------##
## Plot the temporal expression of each individual
graphics::matplot(t(rbind(DATAclustSIM[, 1:3], DATAclustSIM[, 4:6],
                          DATAclustSIM[, 7:9], DATAclustSIM[, 10:12])),
                  col=rep(c("black", "red"), each=6*10),
                  xlab="Time", ylab="Gene expression", type=c("b"), pch=19)

##------------------------------------------------------------------------##
## Preprocessing step
DATAclustSIM <- data.frame(DATAclustSIM)

resDATAprepSE <- DATAprepSE(RawCounts=DATAclustSIM,
                            Column.gene=NULL,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
## Normalization
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=FALSE,
                             Colored.By.Factors=FALSE)
##------------------------------------------------------------------------##
resMFUZZ <- MFUZZanalysis(SEresNorm=resNorm,
                          DATAnorm=TRUE,
                          DataNumberCluster=NULL,
                          Membership=0.5,
                          Min.std=0.1,
                          Plot.Mfuzz=TRUE,
                          path.result=NULL)
}
\seealso{
The function uses the function
\code{\link[=MFUZZclustersNumber]{MFUZZclustersNumber()}}
to compute the optimal number of cluster for each biological condition
with the kmeans method.
}
