#' @name Lee_2019
#'
#' @aliases sps_hilic
#' @aliases sps_rplc
#' @aliases msexp_hilic
#' @aliases msexp_rplc
#'
#' @title Example data for \code{MsQuality}: data set of Lee et al. (2019)
#'
#' @description
#' The data set of Lee et al. (2019) contains metabolite information measured
#' by reverse phase liquid chromatography (RPLC) coupled to mass spectrometry
#' and hydrophilic interaction liquid chromatography (HILIC) coupled to mass 
#' spectrometry (file `STables - rev1.xlsx` in the Supplementary Information).
#'
#' It will be used as an example data set in the vignette to
#' show the functionality of the packages. The file contains \code{Spectra} and
#' \code{MsExperiment} objects that store the mass spectrometry data.
#'
#' @references 
#' Lee et al. (2019). A large-scale analysis of targeted metabolomics data from 
#' heterogeneous biological samples provides insights into metabolite dynamics.
#' Metabolomics, 103, doi: 10.1007/s11306-019-1564-8. 
#'
#' @docType data
#'
#' @return \code{Spectra} and \code{MsExperiment} objects
#'
#' @format \code{Spectra} and \code{MsExperiment}
#' 
#' @source
#' See the file \code{Lee2019-data-source.R} in \code{scripts} for the 
#' source code how \code{sps_hilic} and \code{sps_rplc} were created.
#' 
#' @author Thomas Naake, \email{thomasnaake@@googlemail.com}
NULL

