% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validPeaksMatrix}
\alias{validPeaksMatrix}
\title{Validation functions}
\usage{
validPeaksMatrix(x)
}
\arguments{
\item{x}{object to test.}
}
\value{
\code{logical(1)}, \code{TRUE} if validation are successful otherwise an error
is thrown.
}
\description{
These functions are used to validate input arguments. In general they are
just wrapper around their corresponding \verb{is*} function with an error message.
}
\details{
\code{validPeaksMatrix}: see \code{\link{isPeaksMatrix}}.
}
\examples{
try(validPeaksMatrix(1:2))
validPeaksMatrix(cbind(mz = 1:2, intensity = 1:2))
}
\seealso{
Other helper functions for developers: 
\code{\link{between}()},
\code{\link{isPeaksMatrix}()},
\code{\link{rbindFill}()},
\code{\link{vapply1c}()},
\code{\link{which.first}()}
}
\author{
Sebastian Gibb
}
\concept{helper functions for developers}
