% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnps.R
\name{gnps}
\alias{gnps}
\alias{join_gnps}
\title{GNPS spectrum similarity scores}
\usage{
gnps(x, y, ...)

join_gnps(
  x,
  y,
  xPrecursorMz = NA_real_,
  yPrecursorMz = NA_real_,
  tolerance = 0,
  ppm = 0,
  type = "outer",
  ...
)
}
\arguments{
\item{x}{for \code{join_gnps}: \code{numeric} with m/z values from a spectrum. For
\code{gnps}: \code{matrix} with two columns \code{"mz"} and \code{"intensity"} containing
the peaks \strong{aligned} with peaks in \code{y} (with \code{join_gnps}).}

\item{y}{for \code{join_gnps}: \code{numeric} with m/z values from a spectrum. For
\code{gnps}: \code{matrix} with two columns \code{"mz"} and \code{"intensity"} containing
the peaks \strong{aligned} with peaks in \code{x} (with \code{join_gnps}).}

\item{...}{for \code{join_gnps}: optional parameters passed to the \code{\link[=join]{join()}}
function. For \code{gnps}: ignored.}

\item{xPrecursorMz}{for \code{join_gnps}: \code{numeric(1)} with the precursor m/z
of the spectrum \code{x}.}

\item{yPrecursorMz}{for \code{join_gnps}: \code{numeric(1)} with the precursor m/z
of the spectrum \code{y}.}

\item{tolerance}{for \code{join_gnps}: \code{numeric(1)} defining a constant maximal
accepted difference between m/z values of peaks from the two spectra to
be matched/mapped.}

\item{ppm}{for \code{join_gnps}: \code{numeric(1)} defining a relative, m/z-dependent,
maximal accepted difference between m/z values of peaks from the two
spectra to be matched/mapped.}

\item{type}{for \code{join_gnps}: \code{character(1)} specifying the type of join that
should be performed. See \code{\link[=join]{join()}} for details and options. Defaults to
\code{type = "outer"}.}
}
\value{
See function definition in the description section.
}
\description{
The \code{join_gnps} and \code{gnps} functions allow to calculate spectra similarity
scores as used in \href{https://gnps.ucsd.edu/}{GNPS}. The approach matches first
peaks between the two spectra directly using a user-defined ppm and/or
tolerance as well as using a fixed delta m/z (considering the same ppm and
tolerance) that is defined by the difference of the two spectras' precursor
m/z values. For peaks that match multiple peaks in the
other spectrum only the matching peak pair with the higher value/similarity
is considered in the final similarity score calculation. Note that GNPS
similarity scores are calculated only if the two functions are used together.
\itemize{
\item \code{join_gnps}: matches/maps peaks between spectra with the same approach
as in GNPS: peaks are considered matching if a) the
difference in their m/z values is smaller than defined by \code{tolerance}
and \code{ppm} (this is the same as \code{joinPeaks}) \strong{and} b) the difference of
their m/z \emph{adjusted} for the difference of the spectras' precursor is
smaller than defined by \code{tolerance} and \code{ppm}. Based on this definition,
peaks in \code{x} can match up to two peaks in \code{y} hence returned peak indices
might be duplicated. Note that if one of \code{xPrecursorMz} or \code{yPrecursorMz}
are \code{NA} or if both are the same, the results are the same as with
\code{\link[=join]{join()}}. The function returns a \code{list} of two \code{integer} vectors with the
indices of the peaks matching peaks in the other spectrum or \code{NA}
otherwise.
\item \code{gnps}: calculates the GNPS similarity score on peak matrices' previously
\emph{aligned} (matched) with \code{join_gnps}. For multi-mapping peaks the pair with
the higher similarity are considered in the final score calculation.
}
}
\details{
The implementation of \code{gnps} bases on the R code from the publication listed
in the references.
}
\examples{

## Define spectra
x <- cbind(mz = c(10, 36, 63, 91, 93), intensity = c(14, 15, 999, 650, 1))
y <- cbind(mz = c(10, 12, 50, 63, 105), intensity = c(35, 5, 16, 999, 450))
## The precursor m/z
pmz_x <- 91
pmz_y <- 105

## Plain join identifies only 2 matching peaks
join(x[, 1], y[, 1])

## join_gnps finds 4 matches
join_gnps(x[, 1], y[, 1], pmz_x, pmz_y)

## with one of the two precursor m/z being NA, the result are the same as
## with join.
join_gnps(x[, 1], y[, 1], pmz_x, yPrecursorMz = NA)

## Calculate GNPS similarity score:
map <- join_gnps(x[, 1], y[, 1], pmz_x, pmz_y)
gnps(x[map[[1]], ], y[map[[2]], ])
}
\references{
Xing S, Hu Y, Yin Z, Liu M, Tang X, Fang M, Huan T. Retrieving and Utilizing
Hypothetical Neutral Losses from Tandem Mass Spectra for Spectral Similarity
Analysis and Unknown Metabolite Annotation. \emph{Anal Chem.}
2020 Nov 3;92(21):14476-14483. \doi{10.1021/acs.analchem.0c02521}.
}
\seealso{
Other grouping/matching functions: 
\code{\link{bin}()},
\code{\link{closest}()}

Other distance/similarity functions: 
\code{\link{distance}}
}
\author{
Johannes Rainer, Michael Witting, based on the code from
Xing \emph{et al.} (2020).
}
\concept{distance/similarity functions}
\concept{grouping/matching functions}
