% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_by_vector.R
\name{colCounts}
\alias{colCounts}
\title{Counts the number of features}
\usage{
colCounts(x, ...)
}
\arguments{
\item{x}{A \code{matrix} of mode \code{numeric}.}

\item{...}{Currently ignored.}
}
\value{
A \code{numeric} vector of length identical to \code{ncol(x)}.
}
\description{
Returns the number of non-NA features in a features by sample
matrix.
}
\examples{
m <- matrix(c(1, NA, 2, 3, NA, NA, 4, 5, 6),
            nrow = 3)
colCounts(m)
m <- matrix(rnorm(30), nrow = 3)
colCounts(m)
}
\seealso{
Other Quantitative feature aggregation: 
\code{\link{aggregate}()},
\code{\link{medianPolish}()},
\code{\link{robustSummary}()}
}
\author{
Laurent Gatto
}
\concept{Quantitative feature aggregation}
